clear
set memory 100m
set matsize 80

cd "C:\Documents and Settings\maestas\My Documents\Medicare HMOs\Data"
use hrs_cmsec_clean.dta, clear
cd "C:\Documents and Settings\maestas\My Documents\Medicare HMOs\Output"

*************NEW DESCRIPTIVES************
set more off
log using hhportfolios.log, replace
		
		*construct wealth tertiles
		centile h4atota , centile(33 66)
		gen h4wtert1 = h4atota <=r(c_1)
		gen h4wtert2 = h4atota >r(c_1) & h4atota <=r(c_2)
		gen h4wtert3 = h4atota >r(c_2) & h4atota <.

		sum h4atota h4wtert*

*ownership, everyone 
sum h5anychck h5anycd h5anystck h5anybond h5anyira h5anyrisky2 [aw=r5wgtr]
*shares conditional on owning any financial assets, everyone
sum h5cshchck h5cshcd h5cshstck h5cshbond h5cshira h5crisky2 [aw=r5wgtr] 
*median/means conditional on owning any financial assets, everyone
tabstat h5achck h5acd h5astck h5abond h5aira h5riskass2 if h5totfass2>0 [aw=r5wgtr], stat(mean median)
*median/mean asset values conditional on owning any risky assets
tabstat h5achck h5acd h5astck h5abond h5aira h5riskass2 if h5anyrisky2==1 [aw=r5wgtr], stat(mean median n)

*ownership, by group
bysort r5inscatnew: sum h5anychck h5anycd h5anystck h5anybond h5anyira h5anyrisky2 [aw=r5wgtr]
*shares conditional on owning any financial assets, by group
bysort r5inscatnew: sum h5cshchck h5cshcd h5cshstck h5cshbond h5cshira h5crisky2 [aw=r5wgtr] 
*median/means conditional on owning any financial assets, by group
bysort r5inscatnew: tabstat h5achck h5acd h5astck h5abond h5aira h5riskass2 if h5totfass2>0 [aw=r5wgtr], stat(mean median)
*median/mean asset values conditional on owning any risky assets, by group
bysort r5inscatnew: tabstat h5achck h5acd h5astck h5abond h5aira h5riskass2 if h5anyrisky2==1 [aw=r5wgtr], stat(mean median n)

*STRATIFY risky asset ownership in Table 4 by asset tertiles

*bottom tertile
*ownership
sum h5anyrisky2 [aw=r5wgtr] if h4wtert1==1
bysort r5inscatnew: sum h5anyrisky2 [aw=r5wgtr] if h4wtert1==1
*share
sum h5cshchck h5cshcd h5cshstck h5cshbond h5cshira h5crisky2 [aw=r5wgtr] if h4wtert1==1 & h5totfass2>0 
bysort r5inscatnew: sum h5cshchck h5cshcd h5cshstck h5cshbond h5cshira h5crisky2 [aw=r5wgtr] if h4wtert1==1 & h5totfass2>0

*middle tertile
*ownership
sum h5anyrisky2 [aw=r5wgtr] if h4wtert2==1
bysort r5inscatnew: sum h5anyrisky2 [aw=r5wgtr] if h4wtert2==1
*share
sum h5cshchck h5cshcd h5cshstck h5cshbond h5cshira h5crisky2 [aw=r5wgtr] if h4wtert2==1 & h5totfass2>0 
bysort r5inscatnew: sum h5cshchck h5cshcd h5cshstck h5cshbond h5cshira h5crisky2 [aw=r5wgtr] if h4wtert2==1 & h5totfass2>0

*top tertile
*ownership
sum h5anyrisky2 [aw=r5wgtr] if h4wtert3==1
bysort r5inscatnew: sum h5anyrisky2 [aw=r5wgtr] if h4wtert3==1
*share
sum h5cshchck h5cshcd h5cshstck h5cshbond h5cshira h5crisky2 [aw=r5wgtr] if h4wtert3==1 & h5totfass2>0 
bysort r5inscatnew: sum h5cshchck h5cshcd h5cshstck h5cshbond h5cshira h5crisky2 [aw=r5wgtr] if h4wtert3==1 & h5totfass2>0

/*
*transitions in and out of risky asset ownership
tab h4anyrisky2 h5anyrisky2 [aw=r5wgtr] if r5mdcr==1, cell row col

*transitions in and out of supplements (employer or Medigap)
gen r4supp=r4inscatnew==3 | r4inscatnew==4
gen r5supp=r5inscatnew==3 | r5inscatnew==4

*transitions in and out of Medigap
gen r4supp_mgap=r4inscatnew==4
gen r5supp_mgap=r5inscatnew==4

*transitions in and out of HMOs
gen r4hmo_new=r4inscatnew==2
gen r5hmo_new=r5inscatnew==2

tab r4supp r5supp [aw=r4wgtr] if r5mdcr==1, cell
tab r4supp_mgap r5supp_mgap [aw=r5wgtr] if r5mdcr==1, cell row col
tab r4hmo_new r5hmo_new [aw=r5wgtr] if r5mdcr==1, cell row col
*/

log close


set more off
log using hicoverage.log
tab r5inscatnew [aw=r5wgtr]
log close

set more off
log using oopexpenses.log
tabstat r5oopmd [aw=r5wgtr], stats(n mean median p75 p90 p99)
tabstat r5oopmd [aw=r5wgtr], by(r5inscatnew) stats(n mean median p75 p90 p99) 
tabstat r5oopmd [aw=r5wgtr], by(r5majore) stats(n mean median p75 p90 p99)
tabstat r5oopmd [aw=r5wgtr], by(h5wealthcat) stats(n mean median p75 p90 p99)
tabstat r5oopratio [aw=r5wgtr], by(h5wealthcat) stats(median p75 p90 p99)
log close

*dummy for those who are completely retired, disabled, or not in labor force
gen r5nowork=r5lbrf<=4

set more off
log using samplemeans.log
sum r5agey_e gender1 raedyrs white black hispanic r5married r5nowork h5itot h5atota r5anylife r5smoken r5hibpe r5diabe r5majore r5majors r5fairpoor [aw=r5wgtr]
bysort r5inscatnew: sum r5agey_e gender1 raedyrs white black hispanic r5married r5nowork h5itot h5atota r5anylife r5smoken r5hibpe r5diabe r5majore r5majors r5fairpoor [aw=r5wgtr]
log close



*************OLD DESCRIPTIVES************
/*

log using hhportfolios.log, replace
*mean ownership
summ h5anychck h5anycd h5anystck h5anybond h5anyira h5ownhome h5anyrles h5anybus h5anyrisky2 h5anyrisky4
bysort r5hmo: summ h5anychck h5anycd h5anystck h5anybond h5anyira h5ownhome h5anyrles h5anybus h5anyrisky2 h5anyrisky4 
*unconditional mean shares
summ h5shchck h5shcd h5shstck h5shbond h5shira h5risky2 
bysort r5hmo: summ h5shchck h5shcd h5shstck h5shbond h5shira h5risky2
*mean shares conditional on ownership
summ h5cshchck h5cshcd h5cshstck h5cshbond h5cshira h5crisky2
bysort r5hmo: summ h5cshchck h5cshcd h5cshstck h5cshbond h5cshira h5crisky2
*include house value in assets
summ h5shhouse7 h5shrles7 h5shbsns7 h5risky7 h5anyrisky7
bysort r5hmo: summ h5shhouse7 h5shrles7 h5shbsns7 h5risky7 h5anyrisky7
log close

log using oopexpenses.log, replace
tabstat h5oopmd, by(h5wealthcat) stats(mean p25 median p75 p95 p99)
tabstat h5oopratio, by(h5wealthcat) stats(mean p25 median p75 p95 p99)
tabstat h5anyrisky2, by(h5wealthcat)
tabstat h5oopmd, by(h5majore) stats(mean p25 median p75 p95 p99)
tabstat h5anyrisky2, by(h5majore)
tabstat h5oopmd, by(r5hmo) stats(mean p25 p50 p75 p95 p99)
tabstat h5oopmd, by(h5hmo) stats(mean p25 p50 p75 p95 p99)
*above tabstat is virtually identical if do by r5hmo or h5hmo, stick w/ r5hmo
bysort h5oopcat: tabstat h5risky2, by(h5wealthcat)
bysort h5oopcat: tabstat h5anyrisky2, by(h5wealthcat)
log close

log using hmoenroll.log, replace
tabstat r5hmo, by(r5inscat)
tab r5inscat
summ numplans_org98 numplans_risk98 pctpen98 numplans_org0 numplans_risk0 pctpen0 drisk dpctpen
tab dhmo
log close

log using samplemeans.log, replace
summ r5agey_e gender1-gender2 educ1-educ4 race1-race4 r5married r5divorced r5widowed r5nevmar h5hhres h5ashinctot h5wquart1-h5wquart4 r5privpen r5wkft r5wkpt r5ptret r5ret r5disab h5hibpe h5diabe h5cancre h5lunge h5hearte h5stroke h5psyche h5arthre h5majors r5inscat1-r5inscat4 riskav1-riskav4 r5anylife
bysort r5hmo: summ r5agey_e gender1-gender2 educ1-educ4 race1-race4 r5married r5divorced r5widowed r5nevmar h5hhres h5ashinctot h5wquart1-h5wquart4 r5privpen r5wkft r5wkpt r5ptret r5ret r5disab h5hibpe h5diabe h5cancre h5lunge h5hearte h5stroke h5psyche h5arthre h5majors r5inscat1-r5inscat4 riskav1-riskav4 r5anylife
log close

*fraction with condition in 1998 (r4 is R only, h4 is either R or spouse)
summ r4hibpe r4diabe r4cancre r4lunge r4hearte r4stroke r4psyche r4arthre
summ h4hibpe h4diabe h4cancre h4lunge h4hearte h4stroke h4psyche h4arthre

*change in conditions 1998-2000
summ r5hibps r5diabs r5cancrs r5lungs r5hearts r5stroks r5psychs r5arthrs r5majors r5minors
summ h5hibps h5diabs h5cancrs h5lungs h5hearts h5stroks h5psychs h5arthrs h5majors h5minors

*fraction with condition in 2000
summ r5hibpe r5diabe r5cancre r5lunge r5hearte r5stroke r5psyche r5arthre
summ h5hibpe h5diabe h5cancre h5lunge h5hearte h5stroke h5psyche h5arthre
